#ifndef CC6_LLF_RC4_CONTEXT_DEF_H
#define CC6_LLF_RC4_CONTEXT_DEF_H

/*
 * This file is #included in the middle of the struct declaration for RC4Context_t
 * It contains the platform-specific parts of the context struct. As such:
 *
 *  1) file should not use any includes it is a part of the CRYS_RC4.h file !!!!
 *  2) only the CRYS_RC4.h file should include this file. 
 */


  /*
   *  Object %name    : % LLF_RC4_context_def.h
   *  State           :  %state%
   *  Creation date   :  06 June 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CC6_LLF_RC4_context_def.h#1:incl:1
   *  \author R.Levin 
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* ******************** the additional structure definition ********************* */
   
   struct 
   {
       /* A 4-bytes buffer, containing residuary bytes of input data, which was not  
          processed on previous calling of RC4_Sream function */
       DxUint8_t ResiduaryDataFromPreviousSream[4]; 
   
       /* The number of bytes in the previous update */
       DxUint32_t SizeOfResiduaryData; 
   
	   /* the specific RC4 HW memory: S_box - 256 bytes + 8 bytes  for working with HW */
	   DxUint8_t  RC4_HW_Mem[CRYS_RC4_S_BOX_SIZE_IN_BYTES + 8];     

   } LLF;




#endif


